﻿using System;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace Vimt.JsonWebToken.Messages.Messages
{
    /// <summary>
    /// Vimt Jwt Encrypt Token Request.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VimtJwtEncryptTokenRequest)]
    [DataContract]
    public class VimtJwtEncryptTokenRequest : MessageBase
    {
        /// <summary>
        /// Gets/Sets SAML Token.
        /// </summary>
        [DataMember]
        public string SamlToken { get; set; }
    }
}